package music;

import java.util.ArrayList;

public class Band {
	
	private String name;
	private ArrayList<Musician> members;
	
	public Band(String name, ArrayList<Musician> members) {
		super();
		this.name = name;
		this.members = members;
	}
	
	public Band() {
		super();
		this.members = new ArrayList<Musician>();
	}
	
	public void addMember(Musician member) {
		this.members.add(member);
	}
	
	@Override
	public String toString() {
		StringBuffer band = new StringBuffer();
		band.append(this.name + ':' + '\n');
		for (int i = 0; i < this.members.size(); i++) {
			band.append(members.get(i).toString() + '\n');
		}
		return band.toString();
	}
	
	public void removeMember(Musician member) {
		this.members.remove(member);
	}
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public ArrayList<Musician> getMembers() {
		return members;
	}
	public void setMembers(ArrayList<Musician> members) {
		this.members = members;
	}
	
	

}
